/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.FolderArchiveFile;
import org.eclipse.birt.core.archive.FolderArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.IStreamSorter;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveFileV3;
import org.eclipse.birt.core.archive.compound.ArchiveReader;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.core.i18n.CoreMessages;

public class ArchiveUtil {
    private static final Logger logger = Logger.getLogger(ArchiveUtil.class.getName());
    private static final String IDENTITY_MAPPING = "I";
    private static final String DELETION_MAPPING = "D";
    public static final char UNIX_SEPARATOR_CHAR = '/';
    public static final String UNIX_SEPERATOR = "/";
    public static final String FILE_EXTENSION = ".content";
    static final String READER_COUNT_FILE_NAME = "/.reader.count";
    static final String META_DATA_FILE_NAME = "/.metadata";
    static final String[] SKIP_FILES = new String[]{"/.metadata", "/.reader.count"};

    public static String getFolderPath(String rootPath, String entryName) {
        assert (rootPath != null && entryName != null);
        String path = ArchiveUtil.getFullPath(rootPath, ArchiveUtil.getFilePath(entryName));
        if (path.charAt(path.length() - 1) != '/') {
            path = String.valueOf(path) + '/';
        }
        return path;
    }

    public static String getFilePath(String rootPath, String entryName) {
        assert (rootPath != null && entryName != null);
        String path = ArchiveUtil.getFilePath(entryName);
        return ArchiveUtil.getFullPath(rootPath, String.valueOf(path) + FILE_EXTENSION);
    }

    public static String getFullPath(String root, String relative) {
        StringBuilder sb = new StringBuilder();
        root = ArchiveUtil.toUnixPath(root);
        relative = ArchiveUtil.toUnixPath(relative);
        sb.append(root);
        if (root.charAt(root.length() - 1) != '/') {
            sb.append('/');
        }
        if (relative.length() > 0) {
            int start = relative.charAt(0) == '/' ? 1 : 0;
            sb.append(relative, start, relative.length());
        }
        return sb.toString();
    }

    public static String[] split(String value, char splitChar) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (ch == splitChar) {
                result.add(sb.toString());
                sb.setLength(0);
            } else {
                sb.append(ch);
            }
            ++i;
        }
        result.add(sb.toString());
        return result.toArray(new String[result.size()]);
    }

    public static String getFilePath(String entryName) {
        if (entryName == null || entryName.length() == 0 || entryName.equals(UNIX_SEPERATOR)) {
            return UNIX_SEPERATOR;
        }
        StringBuilder sb = new StringBuilder(entryName.length());
        String[] names = ArchiveUtil.split(entryName, '/');
        int start = 0;
        int end = names.length - 1;
        if (names[start].length() == 0) {
            ++start;
        }
        if (names[end].length() == 0) {
            --end;
        }
        int i = start;
        while (i <= end) {
            sb.append(UNIX_SEPERATOR);
            sb.append(ArchiveUtil.toFileName(names[i]));
            ++i;
        }
        if (names[names.length - 1].length() == 0) {
            sb.append(UNIX_SEPERATOR);
        }
        return sb.toString();
    }

    private static String toFileName(String name) {
        if (name == null || name.length() == 0) {
            return "%2F";
        }
        if (name.equals(".")) {
            return "%2E";
        }
        if (name.equals("..")) {
            return "%2E%2E";
        }
        try {
            String path = URLEncoder.encode(name, "UTF-8");
            if (path.contains(".")) {
                path = path.replaceAll("\\.", "%2E");
            }
            if (path.contains("*")) {
                path = path.replaceAll("\\*", "%2A");
            }
            return path;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return name;
        }
    }

    public static String getEntryName(String filePath) {
        if (filePath == null || filePath.length() == 0 || UNIX_SEPERATOR.equals(filePath)) {
            return UNIX_SEPERATOR;
        }
        StringBuilder sb = new StringBuilder(filePath.length());
        String[] names = ArchiveUtil.split(filePath, '/');
        int start = 0;
        int end = names.length - 1;
        if (names[start].length() == 0) {
            ++start;
        }
        if (names[end].length() == 0) {
            --end;
        }
        int i = start;
        while (i <= end) {
            sb.append(UNIX_SEPERATOR);
            sb.append(ArchiveUtil.toEntryName(names[i]));
            ++i;
        }
        if (names[names.length - 1].length() == 0) {
            sb.append(UNIX_SEPERATOR);
        }
        return sb.toString();
    }

    private static String toEntryName(String path) {
        if (path.equals("%2F")) {
            return "";
        }
        if (path.equals("%2E")) {
            return ".";
        }
        if (path.equals("%2E%2E")) {
            return "..";
        }
        try {
            return URLDecoder.decode(path, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return path;
        }
    }

    public static String getEntryName(String rootPath, String fullPath) {
        String relative = ArchiveUtil.getRelativePath(rootPath, fullPath);
        if (relative.endsWith(FILE_EXTENSION)) {
            relative = relative.substring(0, relative.length() - FILE_EXTENSION.length());
        }
        return ArchiveUtil.getEntryName(relative);
    }

    public static String getRelativePath(String rootPath, String fullPath) {
        String uxRoot = ArchiveUtil.toUnixPath(rootPath);
        String uxPath = ArchiveUtil.toUnixPath(fullPath);
        if (uxRoot.charAt(uxRoot.length() - 1) == '/') {
            uxRoot = uxRoot.substring(0, uxRoot.length() - 1);
        }
        if (!uxPath.startsWith(uxRoot)) {
            throw new IllegalArgumentException(String.valueOf(fullPath) + " must start with " + rootPath);
        }
        String relative = uxPath.substring(uxRoot.length());
        if (relative.length() == 0) {
            return UNIX_SEPERATOR;
        }
        return relative;
    }

    private static String toUnixPath(String path) {
        if (path == null) {
            return null;
        }
        return path.replace('\\', '/');
    }

    public static synchronized String generateUniqueFileFolderName(String originalName) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        String dateTimeString = df.format(new Date());
        StringBuffer folderName = new StringBuffer(originalName);
        folderName.append('_');
        folderName.append(dateTimeString);
        Random generator = new Random();
        File folder = new File(folderName.toString());
        while (folder.exists()) {
            folderName.append(generator.nextInt());
            folder = new File(folderName.toString());
        }
        return folderName.toString();
    }

    public static void createParentFolder(File fd) {
        if (fd != null && fd.getParentFile() != null && !fd.getParentFile().exists()) {
            fd.getParentFile().mkdirs();
        }
    }

    public static void deleteAllFiles(File dirOrFile) {
        if (!dirOrFile.exists()) {
            return;
        }
        if (dirOrFile.isFile()) {
            dirOrFile.delete();
        } else {
            if (dirOrFile.listFiles() != null && dirOrFile.listFiles().length > 0) {
                File[] fileList = dirOrFile.listFiles();
                int i = 0;
                while (i < fileList.length) {
                    ArchiveUtil.deleteAllFiles(fileList[i]);
                    ++i;
                }
            }
            dirOrFile.delete();
        }
    }

    public static void zipFolderToStream(String tempFolderPath, OutputStream ostream) {
        ZipOutputStream zipOutput = new ZipOutputStream(ostream);
        File rootDir = new File(tempFolderPath);
        File[] files = rootDir.listFiles();
        try {
            ArchiveUtil.zipFiles(zipOutput, files, tempFolderPath);
            zipOutput.close();
        }
        catch (FileNotFoundException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    private static void zipFiles(ZipOutputStream zipOut, File[] files, String tempFolderPath) throws FileNotFoundException, IOException {
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                File[] dirFiles = file.listFiles();
                ArchiveUtil.zipFiles(zipOut, dirFiles, tempFolderPath);
            } else {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                try {
                    String relativePath = ArchiveUtil.getEntryName(tempFolderPath, file.getPath());
                    ZipEntry entry = new ZipEntry(relativePath);
                    try {
                        int len;
                        entry.setTime(file.lastModified());
                        zipOut.putNextEntry(entry);
                        byte[] buf = new byte[5120];
                        while ((len = in.read(buf)) > 0) {
                            zipOut.write(buf, 0, len);
                        }
                    }
                    finally {
                        zipOut.closeEntry();
                    }
                }
                finally {
                    in.close();
                }
            }
            ++i;
        }
    }

    public static void unzipArchive(File zipArchive, String tempFolderPath) {
        try {
            ZipFile zipFile = new ZipFile(zipArchive);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    String dirName = ArchiveUtil.getFullPath(tempFolderPath, entry.getName());
                    File dir = new File(dirName);
                    dir.mkdirs();
                    continue;
                }
                InputStream in = null;
                try {
                    in = zipFile.getInputStream(entry);
                    File file = new File(ArchiveUtil.getFullPath(tempFolderPath, entry.getName()));
                    File dir = new File(file.getParent());
                    if (dir.exists()) {
                        assert (dir.isDirectory());
                    } else {
                        dir.mkdirs();
                    }
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                    byte[] buf = new byte[5120];
                    try {
                        int len;
                        while ((len = in.read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            zipFile.close();
        }
        catch (ZipException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public static void copy(IArchiveFile inArchive, IArchiveFile outArchive) throws IOException {
        ArchiveUtil.copy(inArchive, outArchive, new HashMap<String, String>());
    }

    public static void copy(IArchiveFile inArchive, IArchiveFile outArchive, Map<String, String> transformations) throws IOException {
        if (inArchive == null || outArchive == null) {
            throw new IOException(CoreMessages.getString("error.NullSource"));
        }
        if (transformations == null || transformations.isEmpty()) {
            ArchiveUtil.copy(new ArchiveReader(inArchive), new ArchiveWriter(outArchive));
        } else {
            ArchiveUtil.copy(new ArchiveReader(inArchive), new ArchiveWriter(outArchive), transformations);
        }
    }

    public static void copy(IDocArchiveReader reader, IDocArchiveWriter writer) throws IOException {
        List<String> streamList = reader.listAllStreams();
        int i = 0;
        while (i < streamList.size()) {
            String streamPath = streamList.get(i);
            RAInputStream in = reader.getStream(streamPath);
            try {
                RAOutputStream out = writer.createRandomAccessStream(streamPath);
                try {
                    ArchiveUtil.copyStream(in, out);
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void copy(IDocArchiveReader reader, IDocArchiveWriter writer, Map<String, String> transformations) throws IOException {
        void var8_9;
        List<String> streamList = reader.listAllStreams();
        HashMap<String, String> normalizedStreamMappings = new HashMap<String, String>();
        ArrayList<String> overridenStreams = new ArrayList<String>();
        String srcStreamPath = null;
        String targetStreamPath = null;
        boolean bl = false;
        while (var8_9 < streamList.size()) {
            srcStreamPath = streamList.get((int)var8_9);
            targetStreamPath = ArchiveUtil.getTransformedPath(srcStreamPath, transformations);
            if (targetStreamPath != DELETION_MAPPING) {
                normalizedStreamMappings.put(srcStreamPath, targetStreamPath);
                if (targetStreamPath != IDENTITY_MAPPING) {
                    overridenStreams.add(targetStreamPath);
                }
            }
            ++var8_9;
        }
        for (String string : overridenStreams) {
            normalizedStreamMappings.remove(string);
        }
        for (Map.Entry entry : normalizedStreamMappings.entrySet()) {
            srcStreamPath = (String)entry.getKey();
            targetStreamPath = (String)entry.getValue();
            if (targetStreamPath == IDENTITY_MAPPING) {
                targetStreamPath = srcStreamPath;
            }
            RAInputStream in = reader.getStream(srcStreamPath);
            try {
                RAOutputStream out = writer.createRandomAccessStream(targetStreamPath);
                try {
                    ArchiveUtil.copyStream(in, out);
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }
    }

    private static String getTransformedPath(String srcStreamPath, Map<String, String> transformations) {
        Set<Map.Entry<String, String>> transformationSet = transformations.entrySet();
        String srcPatternExpr = null;
        String targetPath = null;
        Pattern pattern = null;
        Matcher matcher = null;
        for (Map.Entry<String, String> entry : transformationSet) {
            srcPatternExpr = entry.getKey();
            pattern = Pattern.compile(srcPatternExpr);
            matcher = pattern.matcher(srcStreamPath);
            int groupCount = 0;
            String groupStr = null;
            String groupToken = null;
            if (!matcher.find()) continue;
            targetPath = entry.getValue();
            if (targetPath == null || targetPath.trim().length() == 0) {
                targetPath = DELETION_MAPPING;
                break;
            }
            groupCount = matcher.groupCount();
            int i = 1;
            while (i <= groupCount) {
                groupStr = matcher.group(i);
                groupToken = "\\\\" + i;
                targetPath = targetPath.replaceAll(groupToken, groupStr);
                ++i;
            }
            break block0;
        }
        if (targetPath == null) {
            targetPath = IDENTITY_MAPPING;
        }
        return targetPath;
    }

    private static void copyStream(RAInputStream in, RAOutputStream out) throws IOException {
        byte[] buf = new byte[4096];
        int readSize = in.read(buf);
        while (readSize != -1) {
            out.write(buf, 0, readSize);
            readSize = in.read(buf);
        }
    }

    public static void archive(String folder, String file) throws IOException {
        ArchiveUtil.archive(folder, null, file);
    }

    public static void convertFolderArchive(String folder, String file) throws IOException {
        FolderArchiveFile folderArchive = new FolderArchiveFile(folder);
        try {
            ArchiveFileV3 fileArchive = new ArchiveFileV3(file, "rw");
            try {
                String dependId;
                ArchiveUtil.copy(folderArchive, fileArchive);
                String systemId = folderArchive.getSystemId();
                if (systemId != null) {
                    fileArchive.setSystemId(systemId);
                }
                if ((dependId = folderArchive.getDependId()) != null) {
                    fileArchive.setDependId(dependId);
                }
            }
            finally {
                fileArchive.close();
            }
        }
        finally {
            folderArchive.close();
        }
    }

    public static void archive(String folderName, IStreamSorter sorter, String fileName) throws IOException {
        folderName = new File(folderName).getCanonicalPath();
        FolderArchiveReader reader = new FolderArchiveReader(folderName);
        try {
            reader.open();
            File file = new File(fileName);
            if (file.exists() && file.isFile()) {
                file.delete();
            }
            FileArchiveWriter writer = new FileArchiveWriter(fileName);
            try {
                writer.initialize();
                ArchiveUtil.copy(reader, writer);
            }
            finally {
                writer.finish();
            }
        }
        finally {
            reader.close();
        }
    }

    public static void archive(String folderName, IStreamSorter sorter, String fileName, boolean contentEscape) throws IOException {
        folderName = new File(folderName).getCanonicalPath();
        FolderArchiveReader reader = new FolderArchiveReader(folderName, contentEscape);
        try {
            reader.open();
            File file = new File(fileName);
            if (file.exists() && file.isFile()) {
                file.delete();
            }
            FileArchiveWriter writer = new FileArchiveWriter(fileName);
            try {
                writer.initialize();
                ArchiveUtil.copy(reader, writer);
            }
            finally {
                writer.finish();
            }
        }
        finally {
            reader.close();
        }
    }

    static boolean needSkip(String file) {
        int i = 0;
        while (i < SKIP_FILES.length) {
            if (SKIP_FILES[i].equals(file)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void listAllFiles(File dir, ArrayList<? super File> fileList) {
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files == null) {
                return;
            }
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.isFile()) {
                    fileList.add(file);
                } else if (file.isDirectory()) {
                    ArchiveUtil.listAllFiles(file, fileList);
                }
                ++i;
            }
        }
    }

    public static void expand(String file, String folder) throws IOException {
        FileArchiveReader reader = new FileArchiveReader(file);
        try {
            reader.open();
            reader.expandFileArchive(folder);
        }
        finally {
            reader.close();
        }
    }

    public static final int bytesToInteger(byte[] b) {
        assert (b.length >= 4);
        return ((b[0] & 0xFF) << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + ((b[3] & 0xFF) << 0);
    }

    public static final int bytesToInteger(byte[] b, int off) {
        assert (b.length - off >= 4);
        return ((b[off++] & 0xFF) << 24) + ((b[off++] & 0xFF) << 16) + ((b[off++] & 0xFF) << 8) + ((b[off] & 0xFF) << 0);
    }

    public static final long bytesToLong(byte[] b) {
        assert (b.length >= 8);
        return (((long)b[0] & 0xFFL) << 56) + (((long)b[1] & 0xFFL) << 48) + (((long)b[2] & 0xFFL) << 40) + (((long)b[3] & 0xFFL) << 32) + (((long)b[4] & 0xFFL) << 24) + (((long)b[5] & 0xFFL) << 16) + (((long)b[6] & 0xFFL) << 8) + (((long)b[7] & 0xFFL) << 0);
    }

    public static final long bytesToLong(byte[] b, int off) {
        assert (b.length - off >= 8);
        return (((long)b[off++] & 0xFFL) << 56) + (((long)b[off++] & 0xFFL) << 48) + (((long)b[off++] & 0xFFL) << 40) + (((long)b[off++] & 0xFFL) << 32) + (((long)b[off++] & 0xFFL) << 24) + (((long)b[off++] & 0xFFL) << 16) + (((long)b[off++] & 0xFFL) << 8) + (((long)b[off] & 0xFFL) << 0);
    }

    public static final void integerToBytes(int v, byte[] b) {
        assert (b.length >= 4);
        b[0] = (byte)(v >>> 24 & 0xFF);
        b[1] = (byte)(v >>> 16 & 0xFF);
        b[2] = (byte)(v >>> 8 & 0xFF);
        b[3] = (byte)(v >>> 0 & 0xFF);
    }

    public static final void integerToBytes(int v, byte[] b, int off) {
        assert (b.length - off >= 4);
        b[off++] = (byte)(v >>> 24 & 0xFF);
        b[off++] = (byte)(v >>> 16 & 0xFF);
        b[off++] = (byte)(v >>> 8 & 0xFF);
        b[off] = (byte)(v >>> 0 & 0xFF);
    }

    public static final void longToBytes(long v, byte[] b) {
        assert (b.length >= 8);
        b[0] = (byte)(v >>> 56 & 0xFFL);
        b[1] = (byte)(v >>> 48 & 0xFFL);
        b[2] = (byte)(v >>> 40 & 0xFFL);
        b[3] = (byte)(v >>> 32 & 0xFFL);
        b[4] = (byte)(v >>> 24 & 0xFFL);
        b[5] = (byte)(v >>> 16 & 0xFFL);
        b[6] = (byte)(v >>> 8 & 0xFFL);
        b[7] = (byte)(v >>> 0 & 0xFFL);
    }

    public static final void longToBytes(long v, byte[] b, int off) {
        assert (b.length - off >= 8);
        b[off++] = (byte)(v >>> 56 & 0xFFL);
        b[off++] = (byte)(v >>> 48 & 0xFFL);
        b[off++] = (byte)(v >>> 40 & 0xFFL);
        b[off++] = (byte)(v >>> 32 & 0xFFL);
        b[off++] = (byte)(v >>> 24 & 0xFFL);
        b[off++] = (byte)(v >>> 16 & 0xFFL);
        b[off++] = (byte)(v >>> 8 & 0xFFL);
        b[off] = (byte)(v >>> 0 & 0xFFL);
    }

    public static boolean removeFileAndFolder(File file) {
        File[] children;
        assert (file != null);
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            int i = 0;
            while (i < children.length) {
                ArchiveUtil.removeFileAndFolder(children[i]);
                ++i;
            }
        }
        if (file.exists()) {
            return file.delete();
        }
        return true;
    }

    public static final IDocArchiveReader createReader(final IDocArchiveWriter writer) {
        return new IDocArchiveReader(){

            @Override
            public String getName() {
                return writer.getName();
            }

            @Override
            public void open() throws IOException {
            }

            @Override
            public RAInputStream getStream(String relativePath) throws IOException {
                return writer.getInputStream(relativePath);
            }

            @Override
            public RAInputStream getInputStream(String relativePath) throws IOException {
                return writer.getInputStream(relativePath);
            }

            @Override
            public boolean exists(String relativePath) {
                return writer.exists(relativePath);
            }

            @Override
            public List<String> listStreams(String relativeStoragePath) throws IOException {
                return writer.listStreams(relativeStoragePath);
            }

            @Override
            public List<String> listAllStreams() throws IOException {
                return writer.listAllStreams();
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public Object lock(String stream) throws IOException {
                return writer.lock(stream);
            }

            @Override
            public void unlock(Object locker) {
                writer.unlock(locker);
            }
        };
    }
}

