/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.utility;

import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PrinterInfo;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterMakeAndModel;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.eclipse.birt.report.utility.ParameterAccessor;
import org.eclipse.birt.report.utility.Printer;

public class PrintUtility {
    public static final String PARAM_PRINTER = "__printer";
    public static final String PARAM_PRINTER_COPIES = "__printer_copies";
    public static final String PARAM_PRINTER_COLLATE = "__printer_collate";
    public static final String PARAM_PRINTER_DUPLEX = "__printer_duplex";
    public static final String PARAM_PRINTER_MODE = "__printer_mode";
    public static final String PARAM_PRINTER_MEDIASIZE = "__printer_pagesize";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execPrint(InputStream inputStream, Printer printer) throws RemoteException {
        MediaSizeName mediaSizeName;
        if (inputStream == null || printer == null) {
            return;
        }
        HashPrintRequestAttributeSet pas = new HashPrintRequestAttributeSet();
        if (printer.isCopiesSupported()) {
            pas.add(new Copies(printer.getCopies()));
        }
        if (printer.isCollateSupported()) {
            pas.add(printer.isCollate() ? SheetCollate.COLLATED : SheetCollate.UNCOLLATED);
        }
        if (printer.isDuplexSupported()) {
            switch (printer.getDuplex()) {
                case 0: {
                    pas.add(Sides.ONE_SIDED);
                    break;
                }
                case 1: {
                    pas.add(Sides.DUPLEX);
                    break;
                }
                case 2: {
                    pas.add(Sides.TUMBLE);
                    break;
                }
                default: {
                    pas.add(Sides.ONE_SIDED);
                }
            }
        }
        if (printer.isModeSupported()) {
            switch (printer.getMode()) {
                case 0: {
                    pas.add(Chromaticity.MONOCHROME);
                    break;
                }
                case 1: {
                    pas.add(Chromaticity.COLOR);
                    break;
                }
                default: {
                    pas.add(Chromaticity.MONOCHROME);
                }
            }
        }
        if (printer.isMediaSupported() && printer.getMediaSize() != null && (mediaSizeName = (MediaSizeName)printer.getMediaSizeNames().get(printer.getMediaSize())) != null) {
            pas.add(mediaSizeName);
        }
        try {
            PrintService service;
            PrintService printService = service = printer.getService();
            synchronized (printService) {
                DocPrintJob job = service.createPrintJob();
                SimpleDoc doc = new SimpleDoc(inputStream, DocFlavor.INPUT_STREAM.POSTSCRIPT, null);
                job.print(doc, pas);
            }
        }
        catch (PrintException e) {
            AxisFault fault = new AxisFault(e.getLocalizedMessage(), (Throwable)e);
            fault.setFaultCode(new QName("PrintUtility.execPrint( )"));
            fault.setFaultString(e.getLocalizedMessage());
            throw fault;
        }
    }

    public static Printer getPrinter(HttpServletRequest request) {
        String printerName = ParameterAccessor.getParameter(request, PARAM_PRINTER);
        Printer printer = null;
        if (printerName != null) {
            List printers = PrintUtility.findPrinters();
            int i = 0;
            while (i < printers.size()) {
                if (printerName.equalsIgnoreCase(((Printer)printers.get(i)).getName())) {
                    printer = (Printer)printers.get(i);
                    break;
                }
                ++i;
            }
        }
        if (printer == null) {
            PrintService service = PrintServiceLookup.lookupDefaultPrintService();
            printer = PrintUtility.createPrinter(service);
        }
        if (printer != null) {
            String mode;
            String duplex;
            String collate;
            String copies = ParameterAccessor.getParameter(request, PARAM_PRINTER_COPIES);
            if (copies != null) {
                printer.setCopies(Integer.parseInt(copies));
            }
            if ((collate = ParameterAccessor.getParameter(request, PARAM_PRINTER_COLLATE)) != null) {
                printer.setCollate(Boolean.valueOf(collate));
            }
            if ((duplex = ParameterAccessor.getParameter(request, PARAM_PRINTER_DUPLEX)) != null) {
                printer.setDuplex(Integer.parseInt(duplex));
            }
            if ((mode = ParameterAccessor.getParameter(request, PARAM_PRINTER_MODE)) != null) {
                printer.setMode(Integer.parseInt(mode));
            }
            String mediaSize = ParameterAccessor.getParameter(request, PARAM_PRINTER_MEDIASIZE);
            if ((mediaSize = ParameterAccessor.htmlDecode(mediaSize)) != null) {
                printer.setMediaSize(mediaSize);
            }
        }
        return printer;
    }

    public static List findPrinters() {
        ArrayList<Printer> printers = new ArrayList<Printer>();
        DocFlavor.INPUT_STREAM flavor = DocFlavor.INPUT_STREAM.POSTSCRIPT;
        HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
        PrintService[] printServices = PrintServiceLookup.lookupPrintServices(flavor, pras);
        if (printServices != null) {
            int i = 0;
            while (i < printServices.length) {
                PrintService service = printServices[i];
                printers.add(PrintUtility.createPrinter(service));
                ++i;
            }
        }
        return printers;
    }

    public static Printer createPrinter(PrintService service) {
        if (service == null) {
            return null;
        }
        Printer printer = new Printer();
        printer.setName(service.getName());
        Cloneable attr = service.getAttribute(PrinterMakeAndModel.class);
        if (attr != null) {
            printer.setModel(attr.toString());
        }
        if ((attr = service.getAttribute(PrinterIsAcceptingJobs.class)) == PrinterIsAcceptingJobs.ACCEPTING_JOBS) {
            printer.setStatus(0);
        } else {
            printer.setStatus(1);
        }
        attr = service.getAttribute(PrinterInfo.class);
        if (attr != null) {
            printer.setInfo(attr.toString());
        }
        printer.setCopiesSupported(service.isAttributeCategorySupported(Copies.class));
        int copies = 0;
        Copies copiesObj = (Copies)service.getDefaultAttributeValue(Copies.class);
        if (copiesObj != null) {
            copies = Integer.parseInt(copiesObj.toString());
        }
        if (copies <= 0) {
            copies = 1;
        }
        printer.setCopies(copies);
        boolean collateSupported = service.isAttributeCategorySupported(SheetCollate.class);
        printer.setCollateSupported(collateSupported);
        if (collateSupported) {
            SheetCollate collate = (SheetCollate)service.getDefaultAttributeValue(SheetCollate.class);
            if (collate == null) {
                collate = SheetCollate.UNCOLLATED;
            }
            if (collate == SheetCollate.COLLATED) {
                printer.setCollate(true);
            } else {
                printer.setCollate(false);
            }
        }
        boolean modeSupported = service.isAttributeCategorySupported(Chromaticity.class);
        printer.setModeSupported(modeSupported);
        if (modeSupported) {
            Chromaticity chromaticity = (Chromaticity)service.getDefaultAttributeValue(Chromaticity.class);
            if (chromaticity == null) {
                chromaticity = Chromaticity.MONOCHROME;
            }
            if (chromaticity == Chromaticity.MONOCHROME) {
                printer.setMode(0);
            } else {
                printer.setMode(1);
            }
        }
        boolean duplexSupported = service.isAttributeCategorySupported(Sides.class);
        printer.setDuplexSupported(duplexSupported);
        if (duplexSupported) {
            Sides sides = (Sides)service.getDefaultAttributeValue(Sides.class);
            if (sides == null) {
                sides = Sides.ONE_SIDED;
            }
            if (sides == Sides.ONE_SIDED) {
                printer.setDuplex(0);
            } else if (sides == Sides.TUMBLE) {
                printer.setDuplex(2);
            } else {
                printer.setDuplex(1);
            }
        }
        boolean mediaSupported = service.isAttributeCategorySupported(Media.class);
        printer.setMediaSupported(mediaSupported);
        if (mediaSupported) {
            Media media;
            Object obj = service.getSupportedAttributeValues(Media.class, null, null);
            if (obj != null && obj instanceof Media[]) {
                Media[] medias = (Media[])obj;
                int j = 0;
                while (j < medias.length) {
                    if (medias[j] instanceof MediaSizeName) {
                        printer.addMediaSizeName(medias[j].toString(), medias[j]);
                    }
                    ++j;
                }
            }
            if ((media = (Media)service.getDefaultAttributeValue(Media.class)) != null && media instanceof MediaSizeName) {
                printer.setMediaSize(media.toString());
            }
        }
        printer.setService(service);
        return printer;
    }

    public static String handleSlash(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '\\') {
                buf.append('\\');
                buf.append('\\');
            } else {
                buf.append(str.charAt(i));
            }
            ++i;
        }
        return buf.toString();
    }
}

