/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.ExceptionInterceptor;
import com.mysql.jdbc.Extension;
import com.mysql.jdbc.MySQLConnection;
import com.mysql.jdbc.NonRegisteringDriver;
import com.mysql.jdbc.PingTarget;
import com.mysql.jdbc.Statement;
import com.mysql.jdbc.log.Log;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationConnection
implements Connection,
PingTarget {
    protected Connection currentConnection;
    protected Connection masterConnection;
    protected Connection slavesConnection;

    protected ReplicationConnection() {
    }

    public ReplicationConnection(Properties masterProperties, Properties slaveProperties) throws SQLException {
        NonRegisteringDriver driver = new NonRegisteringDriver();
        StringBuffer masterUrl = new StringBuffer("jdbc:mysql://");
        StringBuffer slaveUrl = new StringBuffer("jdbc:mysql:loadbalance://");
        String masterHost = masterProperties.getProperty("HOST");
        if (masterHost != null) {
            masterUrl.append(masterHost);
        }
        int numHosts = Integer.parseInt(slaveProperties.getProperty("NUM_HOSTS"));
        for (int i = 1; i <= numHosts; ++i) {
            String slaveHost = slaveProperties.getProperty("HOST." + i);
            if (slaveHost == null) continue;
            if (i > 1) {
                slaveUrl.append(',');
            }
            slaveUrl.append(slaveHost);
        }
        String masterDb = masterProperties.getProperty("DBNAME");
        masterUrl.append("/");
        if (masterDb != null) {
            masterUrl.append(masterDb);
        }
        String slaveDb = slaveProperties.getProperty("DBNAME");
        slaveUrl.append("/");
        if (slaveDb != null) {
            slaveUrl.append(slaveDb);
        }
        slaveProperties.setProperty("roundRobinLoadBalance", "true");
        this.masterConnection = (Connection)driver.connect(masterUrl.toString(), masterProperties);
        this.slavesConnection = (Connection)driver.connect(slaveUrl.toString(), slaveProperties);
        this.slavesConnection.setReadOnly(true);
        this.currentConnection = this.masterConnection;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.currentConnection.clearWarnings();
    }

    @Override
    public synchronized void close() throws SQLException {
        this.masterConnection.close();
        this.slavesConnection.close();
    }

    @Override
    public synchronized void commit() throws SQLException {
        this.currentConnection.commit();
    }

    @Override
    public java.sql.Statement createStatement() throws SQLException {
        java.sql.Statement stmt = this.currentConnection.createStatement();
        ((Statement)stmt).setPingTarget(this);
        return stmt;
    }

    @Override
    public synchronized java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        java.sql.Statement stmt = this.currentConnection.createStatement(resultSetType, resultSetConcurrency);
        ((Statement)stmt).setPingTarget(this);
        return stmt;
    }

    @Override
    public synchronized java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        java.sql.Statement stmt = this.currentConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        ((Statement)stmt).setPingTarget(this);
        return stmt;
    }

    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        return this.currentConnection.getAutoCommit();
    }

    @Override
    public synchronized String getCatalog() throws SQLException {
        return this.currentConnection.getCatalog();
    }

    public synchronized Connection getCurrentConnection() {
        return this.currentConnection;
    }

    @Override
    public synchronized int getHoldability() throws SQLException {
        return this.currentConnection.getHoldability();
    }

    public synchronized Connection getMasterConnection() {
        return this.masterConnection;
    }

    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        return this.currentConnection.getMetaData();
    }

    public synchronized Connection getSlavesConnection() {
        return this.slavesConnection;
    }

    @Override
    public synchronized int getTransactionIsolation() throws SQLException {
        return this.currentConnection.getTransactionIsolation();
    }

    public synchronized Map getTypeMap() throws SQLException {
        return this.currentConnection.getTypeMap();
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        return this.currentConnection.getWarnings();
    }

    @Override
    public synchronized boolean isClosed() throws SQLException {
        return this.currentConnection.isClosed();
    }

    @Override
    public synchronized boolean isReadOnly() throws SQLException {
        return this.currentConnection == this.slavesConnection;
    }

    @Override
    public synchronized String nativeSQL(String sql) throws SQLException {
        return this.currentConnection.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.currentConnection.prepareCall(sql);
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.currentConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.currentConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement pstmt = this.currentConnection.prepareStatement(sql);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement pstmt = this.currentConnection.prepareStatement(sql, autoGeneratedKeys);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement pstmt = this.currentConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement pstmt = this.currentConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement pstmt = this.currentConnection.prepareStatement(sql, columnIndexes);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement pstmt = this.currentConnection.prepareStatement(sql, columnNames);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.currentConnection.releaseSavepoint(savepoint);
    }

    @Override
    public synchronized void rollback() throws SQLException {
        this.currentConnection.rollback();
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        this.currentConnection.rollback(savepoint);
    }

    @Override
    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        this.currentConnection.setAutoCommit(autoCommit);
    }

    @Override
    public synchronized void setCatalog(String catalog) throws SQLException {
        this.currentConnection.setCatalog(catalog);
    }

    @Override
    public synchronized void setHoldability(int holdability) throws SQLException {
        this.currentConnection.setHoldability(holdability);
    }

    @Override
    public synchronized void setReadOnly(boolean readOnly) throws SQLException {
        if (readOnly) {
            if (this.currentConnection != this.slavesConnection) {
                this.switchToSlavesConnection();
            }
        } else if (this.currentConnection != this.masterConnection) {
            this.switchToMasterConnection();
        }
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        return this.currentConnection.setSavepoint();
    }

    @Override
    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        return this.currentConnection.setSavepoint(name);
    }

    @Override
    public synchronized void setTransactionIsolation(int level) throws SQLException {
        this.currentConnection.setTransactionIsolation(level);
    }

    private synchronized void switchToMasterConnection() throws SQLException {
        this.swapConnections(this.masterConnection, this.slavesConnection);
    }

    private synchronized void switchToSlavesConnection() throws SQLException {
        this.swapConnections(this.slavesConnection, this.masterConnection);
    }

    private synchronized void swapConnections(Connection switchToConnection, Connection switchFromConnection) throws SQLException {
        String switchFromCatalog = switchFromConnection.getCatalog();
        String switchToCatalog = switchToConnection.getCatalog();
        if (switchToCatalog != null && !switchToCatalog.equals(switchFromCatalog)) {
            switchToConnection.setCatalog(switchFromCatalog);
        } else if (switchFromCatalog != null) {
            switchToConnection.setCatalog(switchFromCatalog);
        }
        boolean switchToAutoCommit = switchToConnection.getAutoCommit();
        boolean switchFromConnectionAutoCommit = switchFromConnection.getAutoCommit();
        if (switchFromConnectionAutoCommit != switchToAutoCommit) {
            switchToConnection.setAutoCommit(switchFromConnectionAutoCommit);
        }
        int switchToIsolation = switchToConnection.getTransactionIsolation();
        int switchFromIsolation = switchFromConnection.getTransactionIsolation();
        if (switchFromIsolation != switchToIsolation) {
            switchToConnection.setTransactionIsolation(switchFromIsolation);
        }
        this.currentConnection = switchToConnection;
    }

    @Override
    public synchronized void doPing() throws SQLException {
        if (this.masterConnection != null) {
            this.masterConnection.ping();
        }
        if (this.slavesConnection != null) {
            this.slavesConnection.ping();
        }
    }

    @Override
    public synchronized void changeUser(String userName, String newPassword) throws SQLException {
        this.masterConnection.changeUser(userName, newPassword);
        this.slavesConnection.changeUser(userName, newPassword);
    }

    @Override
    public synchronized void clearHasTriedMaster() {
        this.masterConnection.clearHasTriedMaster();
        this.slavesConnection.clearHasTriedMaster();
    }

    @Override
    public synchronized PreparedStatement clientPrepareStatement(String sql) throws SQLException {
        PreparedStatement pstmt = this.currentConnection.clientPrepareStatement(sql);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public synchronized PreparedStatement clientPrepareStatement(String sql, int autoGenKeyIndex) throws SQLException {
        PreparedStatement pstmt = this.currentConnection.clientPrepareStatement(sql, autoGenKeyIndex);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public synchronized PreparedStatement clientPrepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement pstmt = this.currentConnection.clientPrepareStatement(sql, resultSetType, resultSetConcurrency);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public synchronized PreparedStatement clientPrepareStatement(String sql, int[] autoGenKeyIndexes) throws SQLException {
        PreparedStatement pstmt = this.currentConnection.clientPrepareStatement(sql, autoGenKeyIndexes);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public synchronized PreparedStatement clientPrepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement pstmt = this.currentConnection.clientPrepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public synchronized PreparedStatement clientPrepareStatement(String sql, String[] autoGenKeyColNames) throws SQLException {
        PreparedStatement pstmt = this.currentConnection.clientPrepareStatement(sql, autoGenKeyColNames);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public synchronized int getActiveStatementCount() {
        return this.currentConnection.getActiveStatementCount();
    }

    @Override
    public synchronized long getIdleFor() {
        return this.currentConnection.getIdleFor();
    }

    @Override
    public synchronized Log getLog() throws SQLException {
        return this.currentConnection.getLog();
    }

    @Override
    public synchronized String getServerCharacterEncoding() {
        return this.currentConnection.getServerCharacterEncoding();
    }

    @Override
    public synchronized TimeZone getServerTimezoneTZ() {
        return this.currentConnection.getServerTimezoneTZ();
    }

    @Override
    public synchronized String getStatementComment() {
        return this.currentConnection.getStatementComment();
    }

    @Override
    public synchronized boolean hasTriedMaster() {
        return this.currentConnection.hasTriedMaster();
    }

    @Override
    public synchronized void initializeExtension(Extension ex) throws SQLException {
        this.currentConnection.initializeExtension(ex);
    }

    @Override
    public synchronized boolean isAbonormallyLongQuery(long millisOrNanos) {
        return this.currentConnection.isAbonormallyLongQuery(millisOrNanos);
    }

    @Override
    public synchronized boolean isInGlobalTx() {
        return this.currentConnection.isInGlobalTx();
    }

    @Override
    public synchronized boolean isMasterConnection() {
        return this.currentConnection.isMasterConnection();
    }

    @Override
    public synchronized boolean isNoBackslashEscapesSet() {
        return this.currentConnection.isNoBackslashEscapesSet();
    }

    @Override
    public synchronized boolean lowerCaseTableNames() {
        return this.currentConnection.lowerCaseTableNames();
    }

    @Override
    public synchronized boolean parserKnowsUnicode() {
        return this.currentConnection.parserKnowsUnicode();
    }

    @Override
    public synchronized void ping() throws SQLException {
        this.masterConnection.ping();
        this.slavesConnection.ping();
    }

    @Override
    public synchronized void reportQueryTime(long millisOrNanos) {
        this.currentConnection.reportQueryTime(millisOrNanos);
    }

    @Override
    public synchronized void resetServerState() throws SQLException {
        this.currentConnection.resetServerState();
    }

    @Override
    public synchronized PreparedStatement serverPrepareStatement(String sql) throws SQLException {
        PreparedStatement pstmt = this.currentConnection.serverPrepareStatement(sql);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public synchronized PreparedStatement serverPrepareStatement(String sql, int autoGenKeyIndex) throws SQLException {
        PreparedStatement pstmt = this.currentConnection.serverPrepareStatement(sql, autoGenKeyIndex);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public synchronized PreparedStatement serverPrepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement pstmt = this.currentConnection.serverPrepareStatement(sql, resultSetType, resultSetConcurrency);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public synchronized PreparedStatement serverPrepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement pstmt = this.currentConnection.serverPrepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public synchronized PreparedStatement serverPrepareStatement(String sql, int[] autoGenKeyIndexes) throws SQLException {
        PreparedStatement pstmt = this.currentConnection.serverPrepareStatement(sql, autoGenKeyIndexes);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public synchronized PreparedStatement serverPrepareStatement(String sql, String[] autoGenKeyColNames) throws SQLException {
        PreparedStatement pstmt = this.currentConnection.serverPrepareStatement(sql, autoGenKeyColNames);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public synchronized void setFailedOver(boolean flag) {
        this.currentConnection.setFailedOver(flag);
    }

    @Override
    public synchronized void setPreferSlaveDuringFailover(boolean flag) {
        this.currentConnection.setPreferSlaveDuringFailover(flag);
    }

    @Override
    public synchronized void setStatementComment(String comment) {
        this.masterConnection.setStatementComment(comment);
        this.slavesConnection.setStatementComment(comment);
    }

    @Override
    public synchronized void shutdownServer() throws SQLException {
        this.currentConnection.shutdownServer();
    }

    @Override
    public synchronized boolean supportsIsolationLevel() {
        return this.currentConnection.supportsIsolationLevel();
    }

    @Override
    public synchronized boolean supportsQuotedIdentifiers() {
        return this.currentConnection.supportsQuotedIdentifiers();
    }

    @Override
    public synchronized boolean supportsTransactions() {
        return this.currentConnection.supportsTransactions();
    }

    @Override
    public synchronized boolean versionMeetsMinimum(int major, int minor, int subminor) throws SQLException {
        return this.currentConnection.versionMeetsMinimum(major, minor, subminor);
    }

    @Override
    public synchronized String exposeAsXml() throws SQLException {
        return this.currentConnection.exposeAsXml();
    }

    @Override
    public synchronized boolean getAllowLoadLocalInfile() {
        return this.currentConnection.getAllowLoadLocalInfile();
    }

    @Override
    public synchronized boolean getAllowMultiQueries() {
        return this.currentConnection.getAllowMultiQueries();
    }

    @Override
    public synchronized boolean getAllowNanAndInf() {
        return this.currentConnection.getAllowNanAndInf();
    }

    @Override
    public synchronized boolean getAllowUrlInLocalInfile() {
        return this.currentConnection.getAllowUrlInLocalInfile();
    }

    @Override
    public synchronized boolean getAlwaysSendSetIsolation() {
        return this.currentConnection.getAlwaysSendSetIsolation();
    }

    @Override
    public synchronized boolean getAutoClosePStmtStreams() {
        return this.currentConnection.getAutoClosePStmtStreams();
    }

    @Override
    public synchronized boolean getAutoDeserialize() {
        return this.currentConnection.getAutoDeserialize();
    }

    @Override
    public synchronized boolean getAutoGenerateTestcaseScript() {
        return this.currentConnection.getAutoGenerateTestcaseScript();
    }

    @Override
    public synchronized boolean getAutoReconnectForPools() {
        return this.currentConnection.getAutoReconnectForPools();
    }

    @Override
    public synchronized boolean getAutoSlowLog() {
        return this.currentConnection.getAutoSlowLog();
    }

    @Override
    public synchronized int getBlobSendChunkSize() {
        return this.currentConnection.getBlobSendChunkSize();
    }

    @Override
    public synchronized boolean getBlobsAreStrings() {
        return this.currentConnection.getBlobsAreStrings();
    }

    @Override
    public synchronized boolean getCacheCallableStatements() {
        return this.currentConnection.getCacheCallableStatements();
    }

    @Override
    public synchronized boolean getCacheCallableStmts() {
        return this.currentConnection.getCacheCallableStmts();
    }

    @Override
    public synchronized boolean getCachePrepStmts() {
        return this.currentConnection.getCachePrepStmts();
    }

    @Override
    public synchronized boolean getCachePreparedStatements() {
        return this.currentConnection.getCachePreparedStatements();
    }

    @Override
    public synchronized boolean getCacheResultSetMetadata() {
        return this.currentConnection.getCacheResultSetMetadata();
    }

    @Override
    public synchronized boolean getCacheServerConfiguration() {
        return this.currentConnection.getCacheServerConfiguration();
    }

    @Override
    public synchronized int getCallableStatementCacheSize() {
        return this.currentConnection.getCallableStatementCacheSize();
    }

    @Override
    public synchronized int getCallableStmtCacheSize() {
        return this.currentConnection.getCallableStmtCacheSize();
    }

    @Override
    public synchronized boolean getCapitalizeTypeNames() {
        return this.currentConnection.getCapitalizeTypeNames();
    }

    @Override
    public synchronized String getCharacterSetResults() {
        return this.currentConnection.getCharacterSetResults();
    }

    @Override
    public synchronized String getClientCertificateKeyStorePassword() {
        return this.currentConnection.getClientCertificateKeyStorePassword();
    }

    @Override
    public synchronized String getClientCertificateKeyStoreType() {
        return this.currentConnection.getClientCertificateKeyStoreType();
    }

    @Override
    public synchronized String getClientCertificateKeyStoreUrl() {
        return this.currentConnection.getClientCertificateKeyStoreUrl();
    }

    @Override
    public synchronized String getClientInfoProvider() {
        return this.currentConnection.getClientInfoProvider();
    }

    @Override
    public synchronized String getClobCharacterEncoding() {
        return this.currentConnection.getClobCharacterEncoding();
    }

    @Override
    public synchronized boolean getClobberStreamingResults() {
        return this.currentConnection.getClobberStreamingResults();
    }

    @Override
    public synchronized int getConnectTimeout() {
        return this.currentConnection.getConnectTimeout();
    }

    @Override
    public synchronized String getConnectionCollation() {
        return this.currentConnection.getConnectionCollation();
    }

    @Override
    public synchronized String getConnectionLifecycleInterceptors() {
        return this.currentConnection.getConnectionLifecycleInterceptors();
    }

    @Override
    public synchronized boolean getContinueBatchOnError() {
        return this.currentConnection.getContinueBatchOnError();
    }

    @Override
    public synchronized boolean getCreateDatabaseIfNotExist() {
        return this.currentConnection.getCreateDatabaseIfNotExist();
    }

    @Override
    public synchronized int getDefaultFetchSize() {
        return this.currentConnection.getDefaultFetchSize();
    }

    @Override
    public synchronized boolean getDontTrackOpenResources() {
        return this.currentConnection.getDontTrackOpenResources();
    }

    @Override
    public synchronized boolean getDumpMetadataOnColumnNotFound() {
        return this.currentConnection.getDumpMetadataOnColumnNotFound();
    }

    @Override
    public synchronized boolean getDumpQueriesOnException() {
        return this.currentConnection.getDumpQueriesOnException();
    }

    @Override
    public synchronized boolean getDynamicCalendars() {
        return this.currentConnection.getDynamicCalendars();
    }

    @Override
    public synchronized boolean getElideSetAutoCommits() {
        return this.currentConnection.getElideSetAutoCommits();
    }

    @Override
    public synchronized boolean getEmptyStringsConvertToZero() {
        return this.currentConnection.getEmptyStringsConvertToZero();
    }

    @Override
    public synchronized boolean getEmulateLocators() {
        return this.currentConnection.getEmulateLocators();
    }

    @Override
    public synchronized boolean getEmulateUnsupportedPstmts() {
        return this.currentConnection.getEmulateUnsupportedPstmts();
    }

    @Override
    public synchronized boolean getEnablePacketDebug() {
        return this.currentConnection.getEnablePacketDebug();
    }

    @Override
    public synchronized boolean getEnableQueryTimeouts() {
        return this.currentConnection.getEnableQueryTimeouts();
    }

    @Override
    public synchronized String getEncoding() {
        return this.currentConnection.getEncoding();
    }

    @Override
    public synchronized boolean getExplainSlowQueries() {
        return this.currentConnection.getExplainSlowQueries();
    }

    @Override
    public synchronized boolean getFailOverReadOnly() {
        return this.currentConnection.getFailOverReadOnly();
    }

    @Override
    public synchronized boolean getFunctionsNeverReturnBlobs() {
        return this.currentConnection.getFunctionsNeverReturnBlobs();
    }

    @Override
    public synchronized boolean getGatherPerfMetrics() {
        return this.currentConnection.getGatherPerfMetrics();
    }

    @Override
    public synchronized boolean getGatherPerformanceMetrics() {
        return this.currentConnection.getGatherPerformanceMetrics();
    }

    @Override
    public synchronized boolean getGenerateSimpleParameterMetadata() {
        return this.currentConnection.getGenerateSimpleParameterMetadata();
    }

    @Override
    public synchronized boolean getHoldResultsOpenOverStatementClose() {
        return this.currentConnection.getHoldResultsOpenOverStatementClose();
    }

    @Override
    public synchronized boolean getIgnoreNonTxTables() {
        return this.currentConnection.getIgnoreNonTxTables();
    }

    @Override
    public synchronized boolean getIncludeInnodbStatusInDeadlockExceptions() {
        return this.currentConnection.getIncludeInnodbStatusInDeadlockExceptions();
    }

    @Override
    public synchronized int getInitialTimeout() {
        return this.currentConnection.getInitialTimeout();
    }

    @Override
    public synchronized boolean getInteractiveClient() {
        return this.currentConnection.getInteractiveClient();
    }

    @Override
    public synchronized boolean getIsInteractiveClient() {
        return this.currentConnection.getIsInteractiveClient();
    }

    @Override
    public synchronized boolean getJdbcCompliantTruncation() {
        return this.currentConnection.getJdbcCompliantTruncation();
    }

    @Override
    public synchronized boolean getJdbcCompliantTruncationForReads() {
        return this.currentConnection.getJdbcCompliantTruncationForReads();
    }

    @Override
    public synchronized String getLargeRowSizeThreshold() {
        return this.currentConnection.getLargeRowSizeThreshold();
    }

    @Override
    public synchronized String getLoadBalanceStrategy() {
        return this.currentConnection.getLoadBalanceStrategy();
    }

    @Override
    public synchronized String getLocalSocketAddress() {
        return this.currentConnection.getLocalSocketAddress();
    }

    @Override
    public synchronized int getLocatorFetchBufferSize() {
        return this.currentConnection.getLocatorFetchBufferSize();
    }

    @Override
    public synchronized boolean getLogSlowQueries() {
        return this.currentConnection.getLogSlowQueries();
    }

    @Override
    public synchronized boolean getLogXaCommands() {
        return this.currentConnection.getLogXaCommands();
    }

    @Override
    public synchronized String getLogger() {
        return this.currentConnection.getLogger();
    }

    @Override
    public synchronized String getLoggerClassName() {
        return this.currentConnection.getLoggerClassName();
    }

    @Override
    public synchronized boolean getMaintainTimeStats() {
        return this.currentConnection.getMaintainTimeStats();
    }

    @Override
    public synchronized int getMaxQuerySizeToLog() {
        return this.currentConnection.getMaxQuerySizeToLog();
    }

    @Override
    public synchronized int getMaxReconnects() {
        return this.currentConnection.getMaxReconnects();
    }

    @Override
    public synchronized int getMaxRows() {
        return this.currentConnection.getMaxRows();
    }

    @Override
    public synchronized int getMetadataCacheSize() {
        return this.currentConnection.getMetadataCacheSize();
    }

    @Override
    public synchronized int getNetTimeoutForStreamingResults() {
        return this.currentConnection.getNetTimeoutForStreamingResults();
    }

    @Override
    public synchronized boolean getNoAccessToProcedureBodies() {
        return this.currentConnection.getNoAccessToProcedureBodies();
    }

    @Override
    public synchronized boolean getNoDatetimeStringSync() {
        return this.currentConnection.getNoDatetimeStringSync();
    }

    @Override
    public synchronized boolean getNoTimezoneConversionForTimeType() {
        return this.currentConnection.getNoTimezoneConversionForTimeType();
    }

    @Override
    public synchronized boolean getNullCatalogMeansCurrent() {
        return this.currentConnection.getNullCatalogMeansCurrent();
    }

    @Override
    public synchronized boolean getNullNamePatternMatchesAll() {
        return this.currentConnection.getNullNamePatternMatchesAll();
    }

    @Override
    public synchronized boolean getOverrideSupportsIntegrityEnhancementFacility() {
        return this.currentConnection.getOverrideSupportsIntegrityEnhancementFacility();
    }

    @Override
    public synchronized int getPacketDebugBufferSize() {
        return this.currentConnection.getPacketDebugBufferSize();
    }

    @Override
    public synchronized boolean getPadCharsWithSpace() {
        return this.currentConnection.getPadCharsWithSpace();
    }

    @Override
    public synchronized boolean getParanoid() {
        return this.currentConnection.getParanoid();
    }

    @Override
    public synchronized boolean getPedantic() {
        return this.currentConnection.getPedantic();
    }

    @Override
    public synchronized boolean getPinGlobalTxToPhysicalConnection() {
        return this.currentConnection.getPinGlobalTxToPhysicalConnection();
    }

    @Override
    public synchronized boolean getPopulateInsertRowWithDefaultValues() {
        return this.currentConnection.getPopulateInsertRowWithDefaultValues();
    }

    @Override
    public synchronized int getPrepStmtCacheSize() {
        return this.currentConnection.getPrepStmtCacheSize();
    }

    @Override
    public synchronized int getPrepStmtCacheSqlLimit() {
        return this.currentConnection.getPrepStmtCacheSqlLimit();
    }

    @Override
    public synchronized int getPreparedStatementCacheSize() {
        return this.currentConnection.getPreparedStatementCacheSize();
    }

    @Override
    public synchronized int getPreparedStatementCacheSqlLimit() {
        return this.currentConnection.getPreparedStatementCacheSqlLimit();
    }

    @Override
    public synchronized boolean getProcessEscapeCodesForPrepStmts() {
        return this.currentConnection.getProcessEscapeCodesForPrepStmts();
    }

    @Override
    public synchronized boolean getProfileSQL() {
        return this.currentConnection.getProfileSQL();
    }

    @Override
    public synchronized boolean getProfileSql() {
        return this.currentConnection.getProfileSql();
    }

    @Override
    public synchronized String getProfilerEventHandler() {
        return this.currentConnection.getProfilerEventHandler();
    }

    @Override
    public synchronized String getPropertiesTransform() {
        return this.currentConnection.getPropertiesTransform();
    }

    @Override
    public synchronized int getQueriesBeforeRetryMaster() {
        return this.currentConnection.getQueriesBeforeRetryMaster();
    }

    @Override
    public synchronized boolean getReconnectAtTxEnd() {
        return this.currentConnection.getReconnectAtTxEnd();
    }

    @Override
    public synchronized boolean getRelaxAutoCommit() {
        return this.currentConnection.getRelaxAutoCommit();
    }

    @Override
    public synchronized int getReportMetricsIntervalMillis() {
        return this.currentConnection.getReportMetricsIntervalMillis();
    }

    @Override
    public synchronized boolean getRequireSSL() {
        return this.currentConnection.getRequireSSL();
    }

    @Override
    public synchronized String getResourceId() {
        return this.currentConnection.getResourceId();
    }

    @Override
    public synchronized int getResultSetSizeThreshold() {
        return this.currentConnection.getResultSetSizeThreshold();
    }

    @Override
    public synchronized boolean getRewriteBatchedStatements() {
        return this.currentConnection.getRewriteBatchedStatements();
    }

    @Override
    public synchronized boolean getRollbackOnPooledClose() {
        return this.currentConnection.getRollbackOnPooledClose();
    }

    @Override
    public synchronized boolean getRoundRobinLoadBalance() {
        return this.currentConnection.getRoundRobinLoadBalance();
    }

    @Override
    public synchronized boolean getRunningCTS13() {
        return this.currentConnection.getRunningCTS13();
    }

    @Override
    public synchronized int getSecondsBeforeRetryMaster() {
        return this.currentConnection.getSecondsBeforeRetryMaster();
    }

    @Override
    public synchronized int getSelfDestructOnPingMaxOperations() {
        return this.currentConnection.getSelfDestructOnPingMaxOperations();
    }

    @Override
    public synchronized int getSelfDestructOnPingSecondsLifetime() {
        return this.currentConnection.getSelfDestructOnPingSecondsLifetime();
    }

    @Override
    public synchronized String getServerTimezone() {
        return this.currentConnection.getServerTimezone();
    }

    @Override
    public synchronized String getSessionVariables() {
        return this.currentConnection.getSessionVariables();
    }

    @Override
    public synchronized int getSlowQueryThresholdMillis() {
        return this.currentConnection.getSlowQueryThresholdMillis();
    }

    @Override
    public synchronized long getSlowQueryThresholdNanos() {
        return this.currentConnection.getSlowQueryThresholdNanos();
    }

    @Override
    public synchronized String getSocketFactory() {
        return this.currentConnection.getSocketFactory();
    }

    @Override
    public synchronized String getSocketFactoryClassName() {
        return this.currentConnection.getSocketFactoryClassName();
    }

    @Override
    public synchronized int getSocketTimeout() {
        return this.currentConnection.getSocketTimeout();
    }

    @Override
    public synchronized String getStatementInterceptors() {
        return this.currentConnection.getStatementInterceptors();
    }

    @Override
    public synchronized boolean getStrictFloatingPoint() {
        return this.currentConnection.getStrictFloatingPoint();
    }

    @Override
    public synchronized boolean getStrictUpdates() {
        return this.currentConnection.getStrictUpdates();
    }

    @Override
    public synchronized boolean getTcpKeepAlive() {
        return this.currentConnection.getTcpKeepAlive();
    }

    @Override
    public synchronized boolean getTcpNoDelay() {
        return this.currentConnection.getTcpNoDelay();
    }

    @Override
    public synchronized int getTcpRcvBuf() {
        return this.currentConnection.getTcpRcvBuf();
    }

    @Override
    public synchronized int getTcpSndBuf() {
        return this.currentConnection.getTcpSndBuf();
    }

    @Override
    public synchronized int getTcpTrafficClass() {
        return this.currentConnection.getTcpTrafficClass();
    }

    @Override
    public synchronized boolean getTinyInt1isBit() {
        return this.currentConnection.getTinyInt1isBit();
    }

    @Override
    public synchronized boolean getTraceProtocol() {
        return this.currentConnection.getTraceProtocol();
    }

    @Override
    public synchronized boolean getTransformedBitIsBoolean() {
        return this.currentConnection.getTransformedBitIsBoolean();
    }

    @Override
    public synchronized boolean getTreatUtilDateAsTimestamp() {
        return this.currentConnection.getTreatUtilDateAsTimestamp();
    }

    @Override
    public synchronized String getTrustCertificateKeyStorePassword() {
        return this.currentConnection.getTrustCertificateKeyStorePassword();
    }

    @Override
    public synchronized String getTrustCertificateKeyStoreType() {
        return this.currentConnection.getTrustCertificateKeyStoreType();
    }

    @Override
    public synchronized String getTrustCertificateKeyStoreUrl() {
        return this.currentConnection.getTrustCertificateKeyStoreUrl();
    }

    @Override
    public synchronized boolean getUltraDevHack() {
        return this.currentConnection.getUltraDevHack();
    }

    @Override
    public synchronized boolean getUseBlobToStoreUTF8OutsideBMP() {
        return this.currentConnection.getUseBlobToStoreUTF8OutsideBMP();
    }

    @Override
    public synchronized boolean getUseCompression() {
        return this.currentConnection.getUseCompression();
    }

    @Override
    public synchronized String getUseConfigs() {
        return this.currentConnection.getUseConfigs();
    }

    @Override
    public synchronized boolean getUseCursorFetch() {
        return this.currentConnection.getUseCursorFetch();
    }

    @Override
    public synchronized boolean getUseDirectRowUnpack() {
        return this.currentConnection.getUseDirectRowUnpack();
    }

    @Override
    public synchronized boolean getUseDynamicCharsetInfo() {
        return this.currentConnection.getUseDynamicCharsetInfo();
    }

    @Override
    public synchronized boolean getUseFastDateParsing() {
        return this.currentConnection.getUseFastDateParsing();
    }

    @Override
    public synchronized boolean getUseFastIntParsing() {
        return this.currentConnection.getUseFastIntParsing();
    }

    @Override
    public synchronized boolean getUseGmtMillisForDatetimes() {
        return this.currentConnection.getUseGmtMillisForDatetimes();
    }

    @Override
    public synchronized boolean getUseHostsInPrivileges() {
        return this.currentConnection.getUseHostsInPrivileges();
    }

    @Override
    public synchronized boolean getUseInformationSchema() {
        return this.currentConnection.getUseInformationSchema();
    }

    @Override
    public synchronized boolean getUseJDBCCompliantTimezoneShift() {
        return this.currentConnection.getUseJDBCCompliantTimezoneShift();
    }

    @Override
    public synchronized boolean getUseJvmCharsetConverters() {
        return this.currentConnection.getUseJvmCharsetConverters();
    }

    @Override
    public synchronized boolean getUseLegacyDatetimeCode() {
        return this.currentConnection.getUseLegacyDatetimeCode();
    }

    @Override
    public synchronized boolean getUseLocalSessionState() {
        return this.currentConnection.getUseLocalSessionState();
    }

    @Override
    public synchronized boolean getUseNanosForElapsedTime() {
        return this.currentConnection.getUseNanosForElapsedTime();
    }

    @Override
    public synchronized boolean getUseOldAliasMetadataBehavior() {
        return this.currentConnection.getUseOldAliasMetadataBehavior();
    }

    @Override
    public synchronized boolean getUseOldUTF8Behavior() {
        return this.currentConnection.getUseOldUTF8Behavior();
    }

    @Override
    public synchronized boolean getUseOnlyServerErrorMessages() {
        return this.currentConnection.getUseOnlyServerErrorMessages();
    }

    @Override
    public synchronized boolean getUseReadAheadInput() {
        return this.currentConnection.getUseReadAheadInput();
    }

    @Override
    public synchronized boolean getUseSSL() {
        return this.currentConnection.getUseSSL();
    }

    @Override
    public synchronized boolean getUseSSPSCompatibleTimezoneShift() {
        return this.currentConnection.getUseSSPSCompatibleTimezoneShift();
    }

    @Override
    public synchronized boolean getUseServerPrepStmts() {
        return this.currentConnection.getUseServerPrepStmts();
    }

    @Override
    public synchronized boolean getUseServerPreparedStmts() {
        return this.currentConnection.getUseServerPreparedStmts();
    }

    @Override
    public synchronized boolean getUseSqlStateCodes() {
        return this.currentConnection.getUseSqlStateCodes();
    }

    @Override
    public synchronized boolean getUseStreamLengthsInPrepStmts() {
        return this.currentConnection.getUseStreamLengthsInPrepStmts();
    }

    @Override
    public synchronized boolean getUseTimezone() {
        return this.currentConnection.getUseTimezone();
    }

    @Override
    public synchronized boolean getUseUltraDevWorkAround() {
        return this.currentConnection.getUseUltraDevWorkAround();
    }

    @Override
    public synchronized boolean getUseUnbufferedInput() {
        return this.currentConnection.getUseUnbufferedInput();
    }

    @Override
    public synchronized boolean getUseUnicode() {
        return this.currentConnection.getUseUnicode();
    }

    @Override
    public synchronized boolean getUseUsageAdvisor() {
        return this.currentConnection.getUseUsageAdvisor();
    }

    @Override
    public synchronized String getUtf8OutsideBmpExcludedColumnNamePattern() {
        return this.currentConnection.getUtf8OutsideBmpExcludedColumnNamePattern();
    }

    @Override
    public synchronized String getUtf8OutsideBmpIncludedColumnNamePattern() {
        return this.currentConnection.getUtf8OutsideBmpIncludedColumnNamePattern();
    }

    @Override
    public synchronized boolean getVerifyServerCertificate() {
        return this.currentConnection.getVerifyServerCertificate();
    }

    @Override
    public synchronized boolean getYearIsDateType() {
        return this.currentConnection.getYearIsDateType();
    }

    @Override
    public synchronized String getZeroDateTimeBehavior() {
        return this.currentConnection.getZeroDateTimeBehavior();
    }

    @Override
    public synchronized void setAllowLoadLocalInfile(boolean property) {
    }

    @Override
    public synchronized void setAllowMultiQueries(boolean property) {
    }

    @Override
    public synchronized void setAllowNanAndInf(boolean flag) {
    }

    @Override
    public synchronized void setAllowUrlInLocalInfile(boolean flag) {
    }

    @Override
    public synchronized void setAlwaysSendSetIsolation(boolean flag) {
    }

    @Override
    public synchronized void setAutoClosePStmtStreams(boolean flag) {
    }

    @Override
    public synchronized void setAutoDeserialize(boolean flag) {
    }

    @Override
    public synchronized void setAutoGenerateTestcaseScript(boolean flag) {
    }

    @Override
    public synchronized void setAutoReconnect(boolean flag) {
    }

    @Override
    public synchronized void setAutoReconnectForConnectionPools(boolean property) {
    }

    @Override
    public synchronized void setAutoReconnectForPools(boolean flag) {
    }

    @Override
    public synchronized void setAutoSlowLog(boolean flag) {
    }

    @Override
    public synchronized void setBlobSendChunkSize(String value) throws SQLException {
    }

    @Override
    public synchronized void setBlobsAreStrings(boolean flag) {
    }

    @Override
    public synchronized void setCacheCallableStatements(boolean flag) {
    }

    @Override
    public synchronized void setCacheCallableStmts(boolean flag) {
    }

    @Override
    public synchronized void setCachePrepStmts(boolean flag) {
    }

    @Override
    public synchronized void setCachePreparedStatements(boolean flag) {
    }

    @Override
    public synchronized void setCacheResultSetMetadata(boolean property) {
    }

    @Override
    public synchronized void setCacheServerConfiguration(boolean flag) {
    }

    @Override
    public synchronized void setCallableStatementCacheSize(int size) {
    }

    @Override
    public synchronized void setCallableStmtCacheSize(int cacheSize) {
    }

    @Override
    public synchronized void setCapitalizeDBMDTypes(boolean property) {
    }

    @Override
    public synchronized void setCapitalizeTypeNames(boolean flag) {
    }

    @Override
    public synchronized void setCharacterEncoding(String encoding) {
    }

    @Override
    public synchronized void setCharacterSetResults(String characterSet) {
    }

    @Override
    public synchronized void setClientCertificateKeyStorePassword(String value) {
    }

    @Override
    public synchronized void setClientCertificateKeyStoreType(String value) {
    }

    @Override
    public synchronized void setClientCertificateKeyStoreUrl(String value) {
    }

    @Override
    public synchronized void setClientInfoProvider(String classname) {
    }

    @Override
    public synchronized void setClobCharacterEncoding(String encoding) {
    }

    @Override
    public synchronized void setClobberStreamingResults(boolean flag) {
    }

    @Override
    public synchronized void setConnectTimeout(int timeoutMs) {
    }

    @Override
    public synchronized void setConnectionCollation(String collation) {
    }

    @Override
    public synchronized void setConnectionLifecycleInterceptors(String interceptors) {
    }

    @Override
    public synchronized void setContinueBatchOnError(boolean property) {
    }

    @Override
    public synchronized void setCreateDatabaseIfNotExist(boolean flag) {
    }

    @Override
    public synchronized void setDefaultFetchSize(int n) {
    }

    @Override
    public synchronized void setDetectServerPreparedStmts(boolean property) {
    }

    @Override
    public synchronized void setDontTrackOpenResources(boolean flag) {
    }

    @Override
    public synchronized void setDumpMetadataOnColumnNotFound(boolean flag) {
    }

    @Override
    public synchronized void setDumpQueriesOnException(boolean flag) {
    }

    @Override
    public synchronized void setDynamicCalendars(boolean flag) {
    }

    @Override
    public synchronized void setElideSetAutoCommits(boolean flag) {
    }

    @Override
    public synchronized void setEmptyStringsConvertToZero(boolean flag) {
    }

    @Override
    public synchronized void setEmulateLocators(boolean property) {
    }

    @Override
    public synchronized void setEmulateUnsupportedPstmts(boolean flag) {
    }

    @Override
    public synchronized void setEnablePacketDebug(boolean flag) {
    }

    @Override
    public synchronized void setEnableQueryTimeouts(boolean flag) {
    }

    @Override
    public synchronized void setEncoding(String property) {
    }

    @Override
    public synchronized void setExplainSlowQueries(boolean flag) {
    }

    @Override
    public synchronized void setFailOverReadOnly(boolean flag) {
    }

    @Override
    public synchronized void setFunctionsNeverReturnBlobs(boolean flag) {
    }

    @Override
    public synchronized void setGatherPerfMetrics(boolean flag) {
    }

    @Override
    public synchronized void setGatherPerformanceMetrics(boolean flag) {
    }

    @Override
    public synchronized void setGenerateSimpleParameterMetadata(boolean flag) {
    }

    @Override
    public synchronized void setHoldResultsOpenOverStatementClose(boolean flag) {
    }

    @Override
    public synchronized void setIgnoreNonTxTables(boolean property) {
    }

    @Override
    public synchronized void setIncludeInnodbStatusInDeadlockExceptions(boolean flag) {
    }

    @Override
    public synchronized void setInitialTimeout(int property) {
    }

    @Override
    public synchronized void setInteractiveClient(boolean property) {
    }

    @Override
    public synchronized void setIsInteractiveClient(boolean property) {
    }

    @Override
    public synchronized void setJdbcCompliantTruncation(boolean flag) {
    }

    @Override
    public synchronized void setJdbcCompliantTruncationForReads(boolean jdbcCompliantTruncationForReads) {
    }

    @Override
    public synchronized void setLargeRowSizeThreshold(String value) {
    }

    @Override
    public synchronized void setLoadBalanceStrategy(String strategy) {
    }

    @Override
    public synchronized void setLocalSocketAddress(String address) {
    }

    @Override
    public synchronized void setLocatorFetchBufferSize(String value) throws SQLException {
    }

    @Override
    public synchronized void setLogSlowQueries(boolean flag) {
    }

    @Override
    public synchronized void setLogXaCommands(boolean flag) {
    }

    @Override
    public synchronized void setLogger(String property) {
    }

    @Override
    public synchronized void setLoggerClassName(String className) {
    }

    @Override
    public synchronized void setMaintainTimeStats(boolean flag) {
    }

    @Override
    public synchronized void setMaxQuerySizeToLog(int sizeInBytes) {
    }

    @Override
    public synchronized void setMaxReconnects(int property) {
    }

    @Override
    public synchronized void setMaxRows(int property) {
    }

    @Override
    public synchronized void setMetadataCacheSize(int value) {
    }

    @Override
    public synchronized void setNetTimeoutForStreamingResults(int value) {
    }

    @Override
    public synchronized void setNoAccessToProcedureBodies(boolean flag) {
    }

    @Override
    public synchronized void setNoDatetimeStringSync(boolean flag) {
    }

    @Override
    public synchronized void setNoTimezoneConversionForTimeType(boolean flag) {
    }

    @Override
    public synchronized void setNullCatalogMeansCurrent(boolean value) {
    }

    @Override
    public synchronized void setNullNamePatternMatchesAll(boolean value) {
    }

    @Override
    public synchronized void setOverrideSupportsIntegrityEnhancementFacility(boolean flag) {
    }

    @Override
    public synchronized void setPacketDebugBufferSize(int size) {
    }

    @Override
    public synchronized void setPadCharsWithSpace(boolean flag) {
    }

    @Override
    public synchronized void setParanoid(boolean property) {
    }

    @Override
    public synchronized void setPedantic(boolean property) {
    }

    @Override
    public synchronized void setPinGlobalTxToPhysicalConnection(boolean flag) {
    }

    @Override
    public synchronized void setPopulateInsertRowWithDefaultValues(boolean flag) {
    }

    @Override
    public synchronized void setPrepStmtCacheSize(int cacheSize) {
    }

    @Override
    public synchronized void setPrepStmtCacheSqlLimit(int sqlLimit) {
    }

    @Override
    public synchronized void setPreparedStatementCacheSize(int cacheSize) {
    }

    @Override
    public synchronized void setPreparedStatementCacheSqlLimit(int cacheSqlLimit) {
    }

    @Override
    public synchronized void setProcessEscapeCodesForPrepStmts(boolean flag) {
    }

    @Override
    public synchronized void setProfileSQL(boolean flag) {
    }

    @Override
    public synchronized void setProfileSql(boolean property) {
    }

    @Override
    public synchronized void setProfilerEventHandler(String handler) {
    }

    @Override
    public synchronized void setPropertiesTransform(String value) {
    }

    @Override
    public synchronized void setQueriesBeforeRetryMaster(int property) {
    }

    @Override
    public synchronized void setReconnectAtTxEnd(boolean property) {
    }

    @Override
    public synchronized void setRelaxAutoCommit(boolean property) {
    }

    @Override
    public synchronized void setReportMetricsIntervalMillis(int millis) {
    }

    @Override
    public synchronized void setRequireSSL(boolean property) {
    }

    @Override
    public synchronized void setResourceId(String resourceId) {
    }

    @Override
    public synchronized void setResultSetSizeThreshold(int threshold) {
    }

    @Override
    public synchronized void setRetainStatementAfterResultSetClose(boolean flag) {
    }

    @Override
    public synchronized void setRewriteBatchedStatements(boolean flag) {
    }

    @Override
    public synchronized void setRollbackOnPooledClose(boolean flag) {
    }

    @Override
    public synchronized void setRoundRobinLoadBalance(boolean flag) {
    }

    @Override
    public synchronized void setRunningCTS13(boolean flag) {
    }

    @Override
    public synchronized void setSecondsBeforeRetryMaster(int property) {
    }

    @Override
    public synchronized void setSelfDestructOnPingMaxOperations(int maxOperations) {
    }

    @Override
    public synchronized void setSelfDestructOnPingSecondsLifetime(int seconds) {
    }

    @Override
    public synchronized void setServerTimezone(String property) {
    }

    @Override
    public synchronized void setSessionVariables(String variables) {
    }

    @Override
    public synchronized void setSlowQueryThresholdMillis(int millis) {
    }

    @Override
    public synchronized void setSlowQueryThresholdNanos(long nanos) {
    }

    @Override
    public synchronized void setSocketFactory(String name) {
    }

    @Override
    public synchronized void setSocketFactoryClassName(String property) {
    }

    @Override
    public synchronized void setSocketTimeout(int property) {
    }

    @Override
    public synchronized void setStatementInterceptors(String value) {
    }

    @Override
    public synchronized void setStrictFloatingPoint(boolean property) {
    }

    @Override
    public synchronized void setStrictUpdates(boolean property) {
    }

    @Override
    public synchronized void setTcpKeepAlive(boolean flag) {
    }

    @Override
    public synchronized void setTcpNoDelay(boolean flag) {
    }

    @Override
    public synchronized void setTcpRcvBuf(int bufSize) {
    }

    @Override
    public synchronized void setTcpSndBuf(int bufSize) {
    }

    @Override
    public synchronized void setTcpTrafficClass(int classFlags) {
    }

    @Override
    public synchronized void setTinyInt1isBit(boolean flag) {
    }

    @Override
    public synchronized void setTraceProtocol(boolean flag) {
    }

    @Override
    public synchronized void setTransformedBitIsBoolean(boolean flag) {
    }

    @Override
    public synchronized void setTreatUtilDateAsTimestamp(boolean flag) {
    }

    @Override
    public synchronized void setTrustCertificateKeyStorePassword(String value) {
    }

    @Override
    public synchronized void setTrustCertificateKeyStoreType(String value) {
    }

    @Override
    public synchronized void setTrustCertificateKeyStoreUrl(String value) {
    }

    @Override
    public synchronized void setUltraDevHack(boolean flag) {
    }

    @Override
    public synchronized void setUseBlobToStoreUTF8OutsideBMP(boolean flag) {
    }

    @Override
    public synchronized void setUseCompression(boolean property) {
    }

    @Override
    public synchronized void setUseConfigs(String configs) {
    }

    @Override
    public synchronized void setUseCursorFetch(boolean flag) {
    }

    @Override
    public synchronized void setUseDirectRowUnpack(boolean flag) {
    }

    @Override
    public synchronized void setUseDynamicCharsetInfo(boolean flag) {
    }

    @Override
    public synchronized void setUseFastDateParsing(boolean flag) {
    }

    @Override
    public synchronized void setUseFastIntParsing(boolean flag) {
    }

    @Override
    public synchronized void setUseGmtMillisForDatetimes(boolean flag) {
    }

    @Override
    public synchronized void setUseHostsInPrivileges(boolean property) {
    }

    @Override
    public synchronized void setUseInformationSchema(boolean flag) {
    }

    @Override
    public synchronized void setUseJDBCCompliantTimezoneShift(boolean flag) {
    }

    @Override
    public synchronized void setUseJvmCharsetConverters(boolean flag) {
    }

    @Override
    public synchronized void setUseLegacyDatetimeCode(boolean flag) {
    }

    @Override
    public synchronized void setUseLocalSessionState(boolean flag) {
    }

    @Override
    public synchronized void setUseNanosForElapsedTime(boolean flag) {
    }

    @Override
    public synchronized void setUseOldAliasMetadataBehavior(boolean flag) {
    }

    @Override
    public synchronized void setUseOldUTF8Behavior(boolean flag) {
    }

    @Override
    public synchronized void setUseOnlyServerErrorMessages(boolean flag) {
    }

    @Override
    public synchronized void setUseReadAheadInput(boolean flag) {
    }

    @Override
    public synchronized void setUseSSL(boolean property) {
    }

    @Override
    public synchronized void setUseSSPSCompatibleTimezoneShift(boolean flag) {
    }

    @Override
    public synchronized void setUseServerPrepStmts(boolean flag) {
    }

    @Override
    public synchronized void setUseServerPreparedStmts(boolean flag) {
    }

    @Override
    public synchronized void setUseSqlStateCodes(boolean flag) {
    }

    @Override
    public synchronized void setUseStreamLengthsInPrepStmts(boolean property) {
    }

    @Override
    public synchronized void setUseTimezone(boolean property) {
    }

    @Override
    public synchronized void setUseUltraDevWorkAround(boolean property) {
    }

    @Override
    public synchronized void setUseUnbufferedInput(boolean flag) {
    }

    @Override
    public synchronized void setUseUnicode(boolean flag) {
    }

    @Override
    public synchronized void setUseUsageAdvisor(boolean useUsageAdvisorFlag) {
    }

    @Override
    public synchronized void setUtf8OutsideBmpExcludedColumnNamePattern(String regexPattern) {
    }

    @Override
    public synchronized void setUtf8OutsideBmpIncludedColumnNamePattern(String regexPattern) {
    }

    @Override
    public synchronized void setVerifyServerCertificate(boolean flag) {
    }

    @Override
    public synchronized void setYearIsDateType(boolean flag) {
    }

    @Override
    public synchronized void setZeroDateTimeBehavior(String behavior) {
    }

    @Override
    public synchronized boolean useUnbufferedInput() {
        return this.currentConnection.useUnbufferedInput();
    }

    @Override
    public synchronized boolean isSameResource(Connection c) {
        return this.currentConnection.isSameResource(c);
    }

    @Override
    public void setInGlobalTx(boolean flag) {
        this.currentConnection.setInGlobalTx(flag);
    }

    @Override
    public boolean getUseColumnNamesInFindColumn() {
        return this.currentConnection.getUseColumnNamesInFindColumn();
    }

    @Override
    public void setUseColumnNamesInFindColumn(boolean flag) {
    }

    @Override
    public boolean getUseLocalTransactionState() {
        return this.currentConnection.getUseLocalTransactionState();
    }

    @Override
    public void setUseLocalTransactionState(boolean flag) {
    }

    @Override
    public boolean getCompensateOnDuplicateKeyUpdateCounts() {
        return this.currentConnection.getCompensateOnDuplicateKeyUpdateCounts();
    }

    @Override
    public void setCompensateOnDuplicateKeyUpdateCounts(boolean flag) {
    }

    @Override
    public boolean getUseAffectedRows() {
        return this.currentConnection.getUseAffectedRows();
    }

    @Override
    public void setUseAffectedRows(boolean flag) {
    }

    @Override
    public String getPasswordCharacterEncoding() {
        return this.currentConnection.getPasswordCharacterEncoding();
    }

    @Override
    public void setPasswordCharacterEncoding(String characterSet) {
        this.currentConnection.setPasswordCharacterEncoding(characterSet);
    }

    @Override
    public int getAutoIncrementIncrement() {
        return this.currentConnection.getAutoIncrementIncrement();
    }

    @Override
    public int getLoadBalanceBlacklistTimeout() {
        return this.currentConnection.getLoadBalanceBlacklistTimeout();
    }

    @Override
    public void setLoadBalanceBlacklistTimeout(int loadBalanceBlacklistTimeout) {
        this.currentConnection.setLoadBalanceBlacklistTimeout(loadBalanceBlacklistTimeout);
    }

    @Override
    public int getLoadBalancePingTimeout() {
        return this.currentConnection.getLoadBalancePingTimeout();
    }

    @Override
    public void setLoadBalancePingTimeout(int loadBalancePingTimeout) {
        this.currentConnection.setLoadBalancePingTimeout(loadBalancePingTimeout);
    }

    @Override
    public boolean getLoadBalanceValidateConnectionOnSwapServer() {
        return this.currentConnection.getLoadBalanceValidateConnectionOnSwapServer();
    }

    @Override
    public void setLoadBalanceValidateConnectionOnSwapServer(boolean loadBalanceValidateConnectionOnSwapServer) {
        this.currentConnection.setLoadBalanceValidateConnectionOnSwapServer(loadBalanceValidateConnectionOnSwapServer);
    }

    @Override
    public int getRetriesAllDown() {
        return this.currentConnection.getRetriesAllDown();
    }

    @Override
    public void setRetriesAllDown(int retriesAllDown) {
        this.currentConnection.setRetriesAllDown(retriesAllDown);
    }

    @Override
    public ExceptionInterceptor getExceptionInterceptor() {
        return this.currentConnection.getExceptionInterceptor();
    }

    @Override
    public String getExceptionInterceptors() {
        return this.currentConnection.getExceptionInterceptors();
    }

    @Override
    public void setExceptionInterceptors(String exceptionInterceptors) {
        this.currentConnection.setExceptionInterceptors(exceptionInterceptors);
    }

    @Override
    public boolean getQueryTimeoutKillsConnection() {
        return this.currentConnection.getQueryTimeoutKillsConnection();
    }

    @Override
    public void setQueryTimeoutKillsConnection(boolean queryTimeoutKillsConnection) {
        this.currentConnection.setQueryTimeoutKillsConnection(queryTimeoutKillsConnection);
    }

    @Override
    public boolean hasSameProperties(Connection c) {
        return this.masterConnection.hasSameProperties(c) && this.slavesConnection.hasSameProperties(c);
    }

    @Override
    public Properties getProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.masterConnection.getProperties());
        props.putAll((Map<?, ?>)this.slavesConnection.getProperties());
        return props;
    }

    @Override
    public String getHost() {
        return this.currentConnection.getHost();
    }

    @Override
    public void setProxy(MySQLConnection proxy) {
        this.currentConnection.setProxy(proxy);
    }

    @Override
    public synchronized boolean getRetainStatementAfterResultSetClose() {
        return this.currentConnection.getRetainStatementAfterResultSetClose();
    }

    @Override
    public int getMaxAllowedPacket() {
        return this.currentConnection.getMaxAllowedPacket();
    }

    @Override
    public String getLoadBalanceConnectionGroup() {
        return this.currentConnection.getLoadBalanceConnectionGroup();
    }

    @Override
    public boolean getLoadBalanceEnableJMX() {
        return this.currentConnection.getLoadBalanceEnableJMX();
    }

    @Override
    public String getLoadBalanceExceptionChecker() {
        return this.currentConnection.getLoadBalanceExceptionChecker();
    }

    @Override
    public String getLoadBalanceSQLExceptionSubclassFailover() {
        return this.currentConnection.getLoadBalanceSQLExceptionSubclassFailover();
    }

    @Override
    public String getLoadBalanceSQLStateFailover() {
        return this.currentConnection.getLoadBalanceSQLStateFailover();
    }

    @Override
    public void setLoadBalanceConnectionGroup(String loadBalanceConnectionGroup) {
        this.currentConnection.setLoadBalanceConnectionGroup(loadBalanceConnectionGroup);
    }

    @Override
    public void setLoadBalanceEnableJMX(boolean loadBalanceEnableJMX) {
        this.currentConnection.setLoadBalanceEnableJMX(loadBalanceEnableJMX);
    }

    @Override
    public void setLoadBalanceExceptionChecker(String loadBalanceExceptionChecker) {
        this.currentConnection.setLoadBalanceExceptionChecker(loadBalanceExceptionChecker);
    }

    @Override
    public void setLoadBalanceSQLExceptionSubclassFailover(String loadBalanceSQLExceptionSubclassFailover) {
        this.currentConnection.setLoadBalanceSQLExceptionSubclassFailover(loadBalanceSQLExceptionSubclassFailover);
    }

    @Override
    public void setLoadBalanceSQLStateFailover(String loadBalanceSQLStateFailover) {
        this.currentConnection.setLoadBalanceSQLStateFailover(loadBalanceSQLStateFailover);
    }

    @Override
    public String getLoadBalanceAutoCommitStatementRegex() {
        return this.currentConnection.getLoadBalanceAutoCommitStatementRegex();
    }

    @Override
    public int getLoadBalanceAutoCommitStatementThreshold() {
        return this.currentConnection.getLoadBalanceAutoCommitStatementThreshold();
    }

    @Override
    public void setLoadBalanceAutoCommitStatementRegex(String loadBalanceAutoCommitStatementRegex) {
        this.currentConnection.setLoadBalanceAutoCommitStatementRegex(loadBalanceAutoCommitStatementRegex);
    }

    @Override
    public void setLoadBalanceAutoCommitStatementThreshold(int loadBalanceAutoCommitStatementThreshold) {
        this.currentConnection.setLoadBalanceAutoCommitStatementThreshold(loadBalanceAutoCommitStatementThreshold);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
    }

    @Override
    public boolean getIncludeThreadDumpInDeadlockExceptions() {
        return this.currentConnection.getIncludeThreadDumpInDeadlockExceptions();
    }

    @Override
    public void setIncludeThreadDumpInDeadlockExceptions(boolean flag) {
        this.currentConnection.setIncludeThreadDumpInDeadlockExceptions(flag);
    }

    @Override
    public boolean getIncludeThreadNamesAsStatementComment() {
        return this.currentConnection.getIncludeThreadNamesAsStatementComment();
    }

    @Override
    public void setIncludeThreadNamesAsStatementComment(boolean flag) {
        this.currentConnection.setIncludeThreadNamesAsStatementComment(flag);
    }

    @Override
    public synchronized boolean isServerLocal() throws SQLException {
        return this.currentConnection.isServerLocal();
    }

    @Override
    public void setAuthenticationPlugins(String authenticationPlugins) {
        this.currentConnection.setAuthenticationPlugins(authenticationPlugins);
    }

    @Override
    public String getAuthenticationPlugins() {
        return this.currentConnection.getAuthenticationPlugins();
    }

    @Override
    public void setDisabledAuthenticationPlugins(String disabledAuthenticationPlugins) {
        this.currentConnection.setDisabledAuthenticationPlugins(disabledAuthenticationPlugins);
    }

    @Override
    public String getDisabledAuthenticationPlugins() {
        return this.currentConnection.getDisabledAuthenticationPlugins();
    }

    @Override
    public void setDefaultAuthenticationPlugin(String defaultAuthenticationPlugin) {
        this.currentConnection.setDefaultAuthenticationPlugin(defaultAuthenticationPlugin);
    }

    @Override
    public String getDefaultAuthenticationPlugin() {
        return this.currentConnection.getDefaultAuthenticationPlugin();
    }
}

